/*

データクラスはサーバー側で動作する（local Functionを除く）

*/

Class extends EntitySelection





Function exportToFile($file : 4D:C1709.File)->$result : Object
	
	//mark: ファイル化する
	
	If ($file.exists)
		
		$result:={error: "既にファイルが存在する"; filepath: $file.path}
		
	Else 
		
		//mark: 追加モードでファイルを生成
		$fhandle:=$file.open({mode: "append"})
		
		//mark: 必要なフィールドを書き出す
		For each ($row; This:C1470)
			$record:=New collection:C1472
			$record.push($row.Field_string)
			$record.push($row.Field_longint)
			$fhandle.writeLine($record.join("\t")+"\r")
		End for each 
		
		$result:={success: "書き出しました"; filepath: $file.path}
		
	End if 
	
	//mark: -
Function getExportDATA()->$blob : Blob
	
	
	//mark: 一時ファイルを用意
	var $file : 4D:C1709.File
	$file:=File:C1566(Temporary folder:C486+"test.txt"; fk platform path:K87:2)
	
	//mark: 一時ファイルに書き出し
	$result:=This:C1470.exportToFile($file)
	
	//mark:ファイルを取り出して圧縮
	If ($file.exists)
		$blob:=$file.getContent()
		COMPRESS BLOB:C534($blob; Compact compression mode:K22:12)
	End if 
	
	//mark: 一時ファイルを削除
	$file.delete()
	
	
	//mark: -
exposed Function getExportDataEx()->$blob : Blob
	
	//mark: REST経由でBLOBを受け取る
	
	//mark: 一時ファイルを用意
	var $file : 4D:C1709.File
	$file:=File:C1566(Temporary folder:C486+"test.txt"; fk platform path:K87:2)
	
	//mark: 一時ファイルに書き出し
	$result:=This:C1470.exportToFile($file)
	
	//mark:ファイルを取り出して圧縮
	If ($file.exists)
		$blob:=$file.getContent()
		COMPRESS BLOB:C534($blob; Compact compression mode:K22:12)
	End if 
	
	//mark: 一時ファイルを削除
	$file.delete()
	
	
	
	//mark: -
local Function exportToBLOB()->$blob : Blob
	
	//mark: クライアント側でBLOBを受け取る（リモート接続用）
	
	//サーバー側でBLOBを作成
	var $blob : Blob
	$blob:=This:C1470.getExportDATA()
	
	BLOB PROPERTIES:C536($blob; $vlCompressed; $vlExpandedSize; $vlCurrentSize)
	If ($vlCompressed#Is not compressed:K22:11)
		EXPAND BLOB:C535($blob)
	End if 
	
	
	//mark: -
exposed local Function exportToBlobEx()->$blob : Blob
	
	//mark: クライアント側でBLOBを受け取る（REST用）
	
	//サーバー側でBLOBを作成
	var $blob : Blob
	$blob:=This:C1470.getExportDataEx()
	
	BLOB PROPERTIES:C536($blob; $vlCompressed; $vlExpandedSize; $vlCurrentSize)
	If ($vlCompressed#Is not compressed:K22:11)
		EXPAND BLOB:C535($blob)
	End if 
	